package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{StreamMetadata, ChannelArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutMetadataRequest(
    channelArn: ChannelArn,
    metadata: StreamMetadata
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.PutMetadataRequest = {
    import PutMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.PutMetadataRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .metadata(StreamMetadata.unwrap(metadata): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.PutMetadataRequest.ReadOnly =
    zio.aws.ivs.model.PutMetadataRequest.wrap(buildAwsValue())
}
object PutMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.PutMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.PutMetadataRequest =
      zio.aws.ivs.model.PutMetadataRequest(channelArn, metadata)
    def channelArn: ChannelArn
    def metadata: StreamMetadata
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getMetadata: ZIO[Any, Nothing, StreamMetadata] = ZIO.succeed(metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.PutMetadataRequest
  ) extends zio.aws.ivs.model.PutMetadataRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val metadata: StreamMetadata =
      zio.aws.ivs.model.primitives.StreamMetadata(impl.metadata())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.PutMetadataRequest
  ): zio.aws.ivs.model.PutMetadataRequest.ReadOnly = new Wrapper(impl)
}
