package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.ChannelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteChannelRequest(arn: ChannelArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.DeleteChannelRequest = {
    import DeleteChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.DeleteChannelRequest
      .builder()
      .arn(ChannelArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.DeleteChannelRequest.ReadOnly =
    zio.aws.ivs.model.DeleteChannelRequest.wrap(buildAwsValue())
}
object DeleteChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.DeleteChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.DeleteChannelRequest =
      zio.aws.ivs.model.DeleteChannelRequest(arn)
    def arn: ChannelArn
    def getArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.DeleteChannelRequest
  ) extends zio.aws.ivs.model.DeleteChannelRequest.ReadOnly {
    override val arn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.DeleteChannelRequest
  ): zio.aws.ivs.model.DeleteChannelRequest.ReadOnly = new Wrapper(impl)
}
