package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetStreamKeyResponse(
    errors: Optional[Iterable[zio.aws.ivs.model.BatchError]] = Optional.Absent,
    streamKeys: Optional[Iterable[zio.aws.ivs.model.StreamKey]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse = {
    import BatchGetStreamKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        streamKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamKeys)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly =
    zio.aws.ivs.model.BatchGetStreamKeyResponse.wrap(buildAwsValue())
}
object BatchGetStreamKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchGetStreamKeyResponse =
      zio.aws.ivs.model.BatchGetStreamKeyResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[zio.aws.ivs.model.BatchError.ReadOnly]]
    def streamKeys: Optional[List[zio.aws.ivs.model.StreamKey.ReadOnly]]
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
    def getStreamKeys
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.StreamKey.ReadOnly]] =
      AwsError.unwrapOptionField("streamKeys", streamKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ) extends zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly {
    override val errors: Optional[List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.BatchError.wrap(item)
          }.toList
        )
    override val streamKeys
        : Optional[List[zio.aws.ivs.model.StreamKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.StreamKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ): zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly = new Wrapper(impl)
}
