package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.ChannelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetChannelRequest(arns: Iterable[ChannelArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest = {
    import BatchGetChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest
      .builder()
      .arns(arns.map { item =>
        ChannelArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchGetChannelRequest.ReadOnly =
    zio.aws.ivs.model.BatchGetChannelRequest.wrap(buildAwsValue())
}
object BatchGetChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchGetChannelRequest =
      zio.aws.ivs.model.BatchGetChannelRequest(arns)
    def arns: List[ChannelArn]
    def getArns: ZIO[Any, Nothing, List[ChannelArn]] = ZIO.succeed(arns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest
  ) extends zio.aws.ivs.model.BatchGetChannelRequest.ReadOnly {
    override val arns: List[ChannelArn] = impl
      .arns()
      .asScala
      .map { item =>
        zio.aws.ivs.model.primitives.ChannelArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest
  ): zio.aws.ivs.model.BatchGetChannelRequest.ReadOnly = new Wrapper(impl)
}
