package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{PaginationToken, MaxStreamResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamsRequest(
    filterBy: Optional[zio.aws.ivs.model.StreamFilters] = Optional.Absent,
    maxResults: Optional[MaxStreamResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamsRequest
      .builder()
      .optionallyWith(filterBy.map(value => value.buildAwsValue()))(_.filterBy)
      .optionallyWith(
        maxResults.map(value => MaxStreamResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamsRequest.ReadOnly =
    zio.aws.ivs.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamsRequest =
      zio.aws.ivs.model.ListStreamsRequest(
        filterBy.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterBy: Optional[zio.aws.ivs.model.StreamFilters.ReadOnly]
    def maxResults: Optional[MaxStreamResults]
    def nextToken: Optional[PaginationToken]
    def getFilterBy
        : ZIO[Any, AwsError, zio.aws.ivs.model.StreamFilters.ReadOnly] =
      AwsError.unwrapOptionField("filterBy", filterBy)
    def getMaxResults: ZIO[Any, AwsError, MaxStreamResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamsRequest
  ) extends zio.aws.ivs.model.ListStreamsRequest.ReadOnly {
    override val filterBy: Optional[zio.aws.ivs.model.StreamFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterBy())
        .map(value => zio.aws.ivs.model.StreamFilters.wrap(value))
    override val maxResults: Optional[MaxStreamResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ivs.model.primitives.MaxStreamResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamsRequest
  ): zio.aws.ivs.model.ListStreamsRequest.ReadOnly = new Wrapper(impl)
}
