package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait ChannelType {
  def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType
}
object ChannelType {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.ChannelType
  ): zio.aws.ivs.model.ChannelType = value match {
    case software.amazon.awssdk.services.ivs.model.ChannelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.BASIC
  }
  case object STANDARD extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.STANDARD
  }
}
