package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  RecordingConfigurationName,
  RecordingConfigurationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecordingConfiguration(
    arn: RecordingConfigurationArn,
    destinationConfiguration: zio.aws.ivs.model.DestinationConfiguration,
    name: Optional[RecordingConfigurationName] = Optional.Absent,
    state: zio.aws.ivs.model.RecordingConfigurationState,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    thumbnailConfiguration: Optional[zio.aws.ivs.model.ThumbnailConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.RecordingConfiguration = {
    import RecordingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.RecordingConfiguration
      .builder()
      .arn(RecordingConfigurationArn.unwrap(arn): java.lang.String)
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          RecordingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .state(state.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        thumbnailConfiguration.map(value => value.buildAwsValue())
      )(_.thumbnailConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.RecordingConfiguration.ReadOnly =
    zio.aws.ivs.model.RecordingConfiguration.wrap(buildAwsValue())
}
object RecordingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.RecordingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.RecordingConfiguration =
      zio.aws.ivs.model.RecordingConfiguration(
        arn,
        destinationConfiguration.asEditable,
        name.map(value => value),
        state,
        tags.map(value => value),
        thumbnailConfiguration.map(value => value.asEditable)
      )
    def arn: RecordingConfigurationArn
    def destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    def name: Optional[RecordingConfigurationName]
    def state: zio.aws.ivs.model.RecordingConfigurationState
    def tags: Optional[Map[TagKey, TagValue]]
    def thumbnailConfiguration
        : Optional[zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly]
    def getArn: ZIO[Any, Nothing, RecordingConfigurationArn] = ZIO.succeed(arn)
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
    def getName: ZIO[Any, AwsError, RecordingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, Nothing, zio.aws.ivs.model.RecordingConfigurationState] =
      ZIO.succeed(state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getThumbnailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thumbnailConfiguration",
      thumbnailConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.RecordingConfiguration
  ) extends zio.aws.ivs.model.RecordingConfiguration.ReadOnly {
    override val arn: RecordingConfigurationArn =
      zio.aws.ivs.model.primitives.RecordingConfigurationArn(impl.arn())
    override val destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly =
      zio.aws.ivs.model.DestinationConfiguration
        .wrap(impl.destinationConfiguration())
    override val name: Optional[RecordingConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.ivs.model.primitives.RecordingConfigurationName(value)
        )
    override val state: zio.aws.ivs.model.RecordingConfigurationState =
      zio.aws.ivs.model.RecordingConfigurationState.wrap(impl.state())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val thumbnailConfiguration
        : Optional[zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnailConfiguration())
        .map(value => zio.aws.ivs.model.ThumbnailConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.RecordingConfiguration
  ): zio.aws.ivs.model.RecordingConfiguration.ReadOnly = new Wrapper(impl)
}
