package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PlaybackKeyPairArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePlaybackKeyPairRequest(arn: PlaybackKeyPairArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest = {
    import DeletePlaybackKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest
      .builder()
      .arn(PlaybackKeyPairArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.DeletePlaybackKeyPairRequest.ReadOnly =
    zio.aws.ivs.model.DeletePlaybackKeyPairRequest.wrap(buildAwsValue())
}
object DeletePlaybackKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.DeletePlaybackKeyPairRequest =
      zio.aws.ivs.model.DeletePlaybackKeyPairRequest(arn)
    def arn: PlaybackKeyPairArn
    def getArn: ZIO[Any, Nothing, PlaybackKeyPairArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest
  ) extends zio.aws.ivs.model.DeletePlaybackKeyPairRequest.ReadOnly {
    override val arn: PlaybackKeyPairArn =
      zio.aws.ivs.model.primitives.PlaybackKeyPairArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest
  ): zio.aws.ivs.model.DeletePlaybackKeyPairRequest.ReadOnly = new Wrapper(impl)
}
