package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{ErrorMessage, ErrorCode, ResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchError(
    arn: Optional[ResourceArn] = Optional.Absent,
    code: Optional[ErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.BatchError = {
    import BatchError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchError
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        code.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchError.ReadOnly =
    zio.aws.ivs.model.BatchError.wrap(buildAwsValue())
}
object BatchError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.BatchError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchError = zio.aws.ivs.model.BatchError(
      arn.map(value => value),
      code.map(value => value),
      message.map(value => value)
    )
    def arn: Optional[ResourceArn]
    def code: Optional[ErrorCode]
    def message: Optional[ErrorMessage]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchError
  ) extends zio.aws.ivs.model.BatchError.ReadOnly {
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.ResourceArn(value))
    override val code: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.ivs.model.primitives.ErrorCode(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.ivs.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchError
  ): zio.aws.ivs.model.BatchError.ReadOnly = new Wrapper(impl)
}
