package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  PlaybackKeyPairName,
  PlaybackKeyPairArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlaybackKeyPairSummary(
    arn: Optional[PlaybackKeyPairArn] = Optional.Absent,
    name: Optional[PlaybackKeyPairName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary = {
    import PlaybackKeyPairSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary
      .builder()
      .optionallyWith(
        arn.map(value => PlaybackKeyPairArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => PlaybackKeyPairName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly =
    zio.aws.ivs.model.PlaybackKeyPairSummary.wrap(buildAwsValue())
}
object PlaybackKeyPairSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.PlaybackKeyPairSummary =
      zio.aws.ivs.model.PlaybackKeyPairSummary(
        arn.map(value => value),
        name.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[PlaybackKeyPairArn]
    def name: Optional[PlaybackKeyPairName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, PlaybackKeyPairArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, PlaybackKeyPairName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary
  ) extends zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly {
    override val arn: Optional[PlaybackKeyPairArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.PlaybackKeyPairArn(value))
    override val name: Optional[PlaybackKeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.PlaybackKeyPairName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary
  ): zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly = new Wrapper(impl)
}
