package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecordingConfigurationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    recordingConfigurations: Iterable[
      zio.aws.ivs.model.RecordingConfigurationSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse = {
    import ListRecordingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .recordingConfigurations(recordingConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly =
    zio.aws.ivs.model.ListRecordingConfigurationsResponse.wrap(buildAwsValue())
}
object ListRecordingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListRecordingConfigurationsResponse =
      zio.aws.ivs.model.ListRecordingConfigurationsResponse(
        nextToken.map(value => value),
        recordingConfigurations.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def recordingConfigurations
        : List[zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecordingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly
    ]] = ZIO.succeed(recordingConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse
  ) extends zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
    override val recordingConfigurations
        : List[zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly] = impl
      .recordingConfigurations()
      .asScala
      .map { item =>
        zio.aws.ivs.model.RecordingConfigurationSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse
  ): zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
