package zio.aws.ivs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{StreamId, Time}
import scala.jdk.CollectionConverters._
final case class StreamSessionSummary(
    endTime: Optional[Time] = Optional.Absent,
    hasErrorEvent: Optional[Boolean] = Optional.Absent,
    startTime: Optional[Time] = Optional.Absent,
    streamId: Optional[StreamId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StreamSessionSummary = {
    import StreamSessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamSessionSummary
      .builder()
      .optionallyWith(endTime.map(value => Time.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(hasErrorEvent.map(value => value: java.lang.Boolean))(
        _.hasErrorEvent
      )
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamSessionSummary.ReadOnly =
    zio.aws.ivs.model.StreamSessionSummary.wrap(buildAwsValue())
}
object StreamSessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.StreamSessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamSessionSummary =
      zio.aws.ivs.model.StreamSessionSummary(
        endTime.map(value => value),
        hasErrorEvent.map(value => value),
        startTime.map(value => value),
        streamId.map(value => value)
      )
    def endTime: Optional[Time]
    def hasErrorEvent: Optional[Boolean]
    def startTime: Optional[Time]
    def streamId: Optional[StreamId]
    def getEndTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getHasErrorEvent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasErrorEvent", hasErrorEvent)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamSessionSummary
  ) extends zio.aws.ivs.model.StreamSessionSummary.ReadOnly {
    override val endTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ivs.model.primitives.Time(value))
    override val hasErrorEvent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasErrorEvent())
      .map(value => value: Boolean)
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ivs.model.primitives.Time(value))
    override val streamId: Optional[StreamId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.ivs.model.primitives.StreamId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamSessionSummary
  ): zio.aws.ivs.model.StreamSessionSummary.ReadOnly = new Wrapper(impl)
}
