package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  ChannelRecordingConfigurationArn,
  ChannelName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    authorized: Optional[Boolean] = Optional.Absent,
    latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      Optional.Absent,
    name: Optional[ChannelName] = Optional.Absent,
    recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.ivs.model.ChannelType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateChannelRequest
      .builder()
      .optionallyWith(authorized.map(value => value: java.lang.Boolean))(
        _.authorized
      )
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.CreateChannelRequest.ReadOnly =
    zio.aws.ivs.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateChannelRequest =
      zio.aws.ivs.model.CreateChannelRequest(
        authorized.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        recordingConfigurationArn.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def authorized: Optional[Boolean]
    def latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Optional[ChannelName]
    def recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.ivs.model.ChannelType]
    def getAuthorized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.ivs.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ) extends zio.aws.ivs.model.CreateChannelRequest.ReadOnly {
    override val authorized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.authorized())
      .map(value => value: Boolean)
    override val latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val recordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.ivs.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ivs.model.ChannelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ): zio.aws.ivs.model.CreateChannelRequest.ReadOnly = new Wrapper(impl)
}
