package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ChannelRecordingConfigurationArn,
  IsAuthorized,
  TagValue,
  ChannelName,
  ChannelArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelSummary(
    arn: Optional[ChannelArn] = Optional.Absent,
    authorized: Optional[IsAuthorized] = Optional.Absent,
    latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      Optional.Absent,
    name: Optional[ChannelName] = Optional.Absent,
    recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ChannelSummary = {
    import ChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ChannelSummary
      .builder()
      .optionallyWith(
        arn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        authorized.map(value => IsAuthorized.unwrap(value): java.lang.Boolean)
      )(_.authorized)
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ChannelSummary.ReadOnly =
    zio.aws.ivs.model.ChannelSummary.wrap(buildAwsValue())
}
object ChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ChannelSummary =
      zio.aws.ivs.model.ChannelSummary(
        arn.map(value => value),
        authorized.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        recordingConfigurationArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ChannelArn]
    def authorized: Optional[IsAuthorized]
    def latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Optional[ChannelName]
    def recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorized: ZIO[Any, AwsError, IsAuthorized] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ChannelSummary
  ) extends zio.aws.ivs.model.ChannelSummary.ReadOnly {
    override val arn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val authorized: Optional[IsAuthorized] = zio.aws.core.internal
      .optionalFromNullable(impl.authorized())
      .map(value => zio.aws.ivs.model.primitives.IsAuthorized(value))
    override val latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val recordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ChannelSummary
  ): zio.aws.ivs.model.ChannelSummary.ReadOnly = new Wrapper(impl)
}
