package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ChannelRecordingConfigurationArn,
  IsAuthorized,
  TagValue,
  IngestEndpoint,
  PlaybackURL,
  ChannelName,
  ChannelArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Channel(
    arn: Optional[ChannelArn] = Optional.Absent,
    authorized: Optional[IsAuthorized] = Optional.Absent,
    ingestEndpoint: Optional[IngestEndpoint] = Optional.Absent,
    latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      Optional.Absent,
    name: Optional[ChannelName] = Optional.Absent,
    playbackUrl: Optional[PlaybackURL] = Optional.Absent,
    recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.ivs.model.ChannelType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.Channel
      .builder()
      .optionallyWith(
        arn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        authorized.map(value => IsAuthorized.unwrap(value): java.lang.Boolean)
      )(_.authorized)
      .optionallyWith(
        ingestEndpoint.map(value =>
          IngestEndpoint.unwrap(value): java.lang.String
        )
      )(_.ingestEndpoint)
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        playbackUrl.map(value => PlaybackURL.unwrap(value): java.lang.String)
      )(_.playbackUrl)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.Channel.ReadOnly =
    zio.aws.ivs.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.Channel] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.Channel = zio.aws.ivs.model.Channel(
      arn.map(value => value),
      authorized.map(value => value),
      ingestEndpoint.map(value => value),
      latencyMode.map(value => value),
      name.map(value => value),
      playbackUrl.map(value => value),
      recordingConfigurationArn.map(value => value),
      tags.map(value => value),
      `type`.map(value => value)
    )
    def arn: Optional[ChannelArn]
    def authorized: Optional[IsAuthorized]
    def ingestEndpoint: Optional[IngestEndpoint]
    def latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Optional[ChannelName]
    def playbackUrl: Optional[PlaybackURL]
    def recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.ivs.model.ChannelType]
    def getArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorized: ZIO[Any, AwsError, IsAuthorized] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getIngestEndpoint: ZIO[Any, AwsError, IngestEndpoint] =
      AwsError.unwrapOptionField("ingestEndpoint", ingestEndpoint)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getPlaybackUrl: ZIO[Any, AwsError, PlaybackURL] =
      AwsError.unwrapOptionField("playbackUrl", playbackUrl)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.ivs.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.Channel
  ) extends zio.aws.ivs.model.Channel.ReadOnly {
    override val arn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val authorized: Optional[IsAuthorized] = zio.aws.core.internal
      .optionalFromNullable(impl.authorized())
      .map(value => zio.aws.ivs.model.primitives.IsAuthorized(value))
    override val ingestEndpoint: Optional[IngestEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestEndpoint())
        .map(value => zio.aws.ivs.model.primitives.IngestEndpoint(value))
    override val latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val playbackUrl: Optional[PlaybackURL] = zio.aws.core.internal
      .optionalFromNullable(impl.playbackUrl())
      .map(value => zio.aws.ivs.model.primitives.PlaybackURL(value))
    override val recordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.ivs.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ivs.model.ChannelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.Channel
  ): zio.aws.ivs.model.Channel.ReadOnly = new Wrapper(impl)
}
