package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamKeysResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    streamKeys: Iterable[zio.aws.ivs.model.StreamKeySummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse = {
    import ListStreamKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .streamKeys(streamKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly =
    zio.aws.ivs.model.ListStreamKeysResponse.wrap(buildAwsValue())
}
object ListStreamKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamKeysResponse =
      zio.aws.ivs.model.ListStreamKeysResponse(
        nextToken.map(value => value),
        streamKeys.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def streamKeys: List[zio.aws.ivs.model.StreamKeySummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamKeys
        : ZIO[Any, Nothing, List[zio.aws.ivs.model.StreamKeySummary.ReadOnly]] =
      ZIO.succeed(streamKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse
  ) extends zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
    override val streamKeys: List[zio.aws.ivs.model.StreamKeySummary.ReadOnly] =
      impl
        .streamKeys()
        .asScala
        .map { item =>
          zio.aws.ivs.model.StreamKeySummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse
  ): zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly = new Wrapper(impl)
}
