package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStreamResponse(
    stream: Optional[zio.aws.ivs.model.Stream] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetStreamResponse = {
    import GetStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetStreamResponse
      .builder()
      .optionallyWith(stream.map(value => value.buildAwsValue()))(_.stream)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetStreamResponse.ReadOnly =
    zio.aws.ivs.model.GetStreamResponse.wrap(buildAwsValue())
}
object GetStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetStreamResponse =
      zio.aws.ivs.model.GetStreamResponse(stream.map(value => value.asEditable))
    def stream: Optional[zio.aws.ivs.model.Stream.ReadOnly]
    def getStream: ZIO[Any, AwsError, zio.aws.ivs.model.Stream.ReadOnly] =
      AwsError.unwrapOptionField("stream", stream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamResponse
  ) extends zio.aws.ivs.model.GetStreamResponse.ReadOnly {
    override val stream: Optional[zio.aws.ivs.model.Stream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stream())
        .map(value => zio.aws.ivs.model.Stream.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamResponse
  ): zio.aws.ivs.model.GetStreamResponse.ReadOnly = new Wrapper(impl)
}
