package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelResponse(
    channel: Optional[zio.aws.ivs.model.Channel] = Optional.Absent,
    streamKey: Optional[zio.aws.ivs.model.StreamKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateChannelResponse = {
    import CreateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(streamKey.map(value => value.buildAwsValue()))(
        _.streamKey
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.CreateChannelResponse.ReadOnly =
    zio.aws.ivs.model.CreateChannelResponse.wrap(buildAwsValue())
}
object CreateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateChannelResponse =
      zio.aws.ivs.model.CreateChannelResponse(
        channel.map(value => value.asEditable),
        streamKey.map(value => value.asEditable)
      )
    def channel: Optional[zio.aws.ivs.model.Channel.ReadOnly]
    def streamKey: Optional[zio.aws.ivs.model.StreamKey.ReadOnly]
    def getChannel: ZIO[Any, AwsError, zio.aws.ivs.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
    def getStreamKey: ZIO[Any, AwsError, zio.aws.ivs.model.StreamKey.ReadOnly] =
      AwsError.unwrapOptionField("streamKey", streamKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelResponse
  ) extends zio.aws.ivs.model.CreateChannelResponse.ReadOnly {
    override val channel: Optional[zio.aws.ivs.model.Channel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.ivs.model.Channel.wrap(value))
    override val streamKey: Optional[zio.aws.ivs.model.StreamKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamKey())
        .map(value => zio.aws.ivs.model.StreamKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelResponse
  ): zio.aws.ivs.model.CreateChannelResponse.ReadOnly = new Wrapper(impl)
}
