package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetChannelResponse(
    channels: Optional[Iterable[zio.aws.ivs.model.Channel]] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.ivs.model.BatchError]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse = {
    import BatchGetChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly =
    zio.aws.ivs.model.BatchGetChannelResponse.wrap(buildAwsValue())
}
object BatchGetChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchGetChannelResponse =
      zio.aws.ivs.model.BatchGetChannelResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channels: Optional[List[zio.aws.ivs.model.Channel.ReadOnly]]
    def errors: Optional[List[zio.aws.ivs.model.BatchError.ReadOnly]]
    def getChannels
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("channels", channels)
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse
  ) extends zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly {
    override val channels: Optional[List[zio.aws.ivs.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.Channel.wrap(item)
          }.toList
        )
    override val errors: Optional[List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.BatchError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse
  ): zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly = new Wrapper(impl)
}
