package zio.aws.ivs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{
  StreamViewerCount,
  StreamId,
  StreamStartTime,
  ChannelArn
}
import scala.jdk.CollectionConverters._
final case class StreamSummary(
    channelArn: Optional[ChannelArn] = Optional.Absent,
    health: Optional[zio.aws.ivs.model.StreamHealth] = Optional.Absent,
    startTime: Optional[StreamStartTime] = Optional.Absent,
    state: Optional[zio.aws.ivs.model.StreamState] = Optional.Absent,
    streamId: Optional[StreamId] = Optional.Absent,
    viewerCount: Optional[StreamViewerCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StreamSummary = {
    import StreamSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamSummary
      .builder()
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .optionallyWith(
        startTime.map(value => StreamStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        viewerCount.map(value =>
          StreamViewerCount.unwrap(value): java.lang.Long
        )
      )(_.viewerCount)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamSummary.ReadOnly =
    zio.aws.ivs.model.StreamSummary.wrap(buildAwsValue())
}
object StreamSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamSummary =
      zio.aws.ivs.model.StreamSummary(
        channelArn.map(value => value),
        health.map(value => value),
        startTime.map(value => value),
        state.map(value => value),
        streamId.map(value => value),
        viewerCount.map(value => value)
      )
    def channelArn: Optional[ChannelArn]
    def health: Optional[zio.aws.ivs.model.StreamHealth]
    def startTime: Optional[StreamStartTime]
    def state: Optional[zio.aws.ivs.model.StreamState]
    def streamId: Optional[StreamId]
    def viewerCount: Optional[StreamViewerCount]
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getHealth: ZIO[Any, AwsError, zio.aws.ivs.model.StreamHealth] =
      AwsError.unwrapOptionField("health", health)
    def getStartTime: ZIO[Any, AwsError, StreamStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ivs.model.StreamState] =
      AwsError.unwrapOptionField("state", state)
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getViewerCount: ZIO[Any, AwsError, StreamViewerCount] =
      AwsError.unwrapOptionField("viewerCount", viewerCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamSummary
  ) extends zio.aws.ivs.model.StreamSummary.ReadOnly {
    override val channelArn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val health: Optional[zio.aws.ivs.model.StreamHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.ivs.model.StreamHealth.wrap(value))
    override val startTime: Optional[StreamStartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ivs.model.primitives.StreamStartTime(value))
    override val state: Optional[zio.aws.ivs.model.StreamState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ivs.model.StreamState.wrap(value))
    override val streamId: Optional[StreamId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.ivs.model.primitives.StreamId(value))
    override val viewerCount: Optional[StreamViewerCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewerCount())
        .map(value => zio.aws.ivs.model.primitives.StreamViewerCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamSummary
  ): zio.aws.ivs.model.StreamSummary.ReadOnly = new Wrapper(impl)
}
