package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamSessionsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    streamSessions: Iterable[zio.aws.ivs.model.StreamSessionSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse = {
    import ListStreamSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .streamSessions(streamSessions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly =
    zio.aws.ivs.model.ListStreamSessionsResponse.wrap(buildAwsValue())
}
object ListStreamSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamSessionsResponse =
      zio.aws.ivs.model.ListStreamSessionsResponse(
        nextToken.map(value => value),
        streamSessions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def streamSessions: List[zio.aws.ivs.model.StreamSessionSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamSessions: ZIO[Any, Nothing, List[
      zio.aws.ivs.model.StreamSessionSummary.ReadOnly
    ]] = ZIO.succeed(streamSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse
  ) extends zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
    override val streamSessions
        : List[zio.aws.ivs.model.StreamSessionSummary.ReadOnly] = impl
      .streamSessions()
      .asScala
      .map { item =>
        zio.aws.ivs.model.StreamSessionSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse
  ): zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly = new Wrapper(impl)
}
