package zio.aws.ivs
import zio.aws.ivs.model.CreateRecordingConfigurationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.ivs.IvsAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ivs.model.{
  StopStreamRequest,
  GetChannelRequest,
  ListPlaybackKeyPairsRequest,
  ListStreamsRequest,
  GetStreamSessionRequest,
  DeleteStreamKeyRequest,
  DeleteChannelRequest,
  CreateChannelRequest,
  ImportPlaybackKeyPairRequest,
  BatchGetStreamKeyRequest,
  ListTagsForResourceRequest,
  GetStreamRequest,
  PutMetadataRequest,
  DeleteRecordingConfigurationRequest,
  GetPlaybackKeyPairRequest,
  BatchGetChannelRequest,
  ListStreamSessionsRequest,
  UpdateChannelRequest,
  GetStreamKeyRequest,
  DeletePlaybackKeyPairRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  CreateStreamKeyRequest,
  ListRecordingConfigurationsRequest,
  CreateRecordingConfigurationRequest,
  ListStreamKeysRequest,
  TagResourceRequest,
  GetRecordingConfigurationRequest
}
object IvsMock extends Mock[Ivs] {
  object ListStreams
      extends Effect[
        ListStreamsRequest,
        AwsError,
        zio.aws.ivs.model.ListStreamsResponse.ReadOnly
      ]
  object ListChannels
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.ivs.model.ListChannelsResponse.ReadOnly
      ]
  object DeletePlaybackKeyPair
      extends Effect[
        DeletePlaybackKeyPairRequest,
        AwsError,
        zio.aws.ivs.model.DeletePlaybackKeyPairResponse.ReadOnly
      ]
  object ListRecordingConfigurations
      extends Effect[
        ListRecordingConfigurationsRequest,
        AwsError,
        zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly
      ]
  object ListStreamKeys
      extends Effect[
        ListStreamKeysRequest,
        AwsError,
        zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly
      ]
  object BatchGetChannel
      extends Effect[
        BatchGetChannelRequest,
        AwsError,
        zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly
      ]
  object GetPlaybackKeyPair
      extends Effect[
        GetPlaybackKeyPairRequest,
        AwsError,
        zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly
      ]
  object GetStreamSession
      extends Effect[
        GetStreamSessionRequest,
        AwsError,
        zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly
      ]
  object ImportPlaybackKeyPair
      extends Effect[
        ImportPlaybackKeyPairRequest,
        AwsError,
        zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly
      ]
  object GetRecordingConfiguration
      extends Effect[
        GetRecordingConfigurationRequest,
        AwsError,
        zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly
      ]
  object PutMetadata extends Effect[PutMetadataRequest, AwsError, Unit]
  object CreateRecordingConfiguration
      extends Effect[CreateRecordingConfigurationRequest, AwsError, ReadOnly]
  object DeleteChannel extends Effect[DeleteChannelRequest, AwsError, Unit]
  object StopStream
      extends Effect[
        StopStreamRequest,
        AwsError,
        zio.aws.ivs.model.StopStreamResponse.ReadOnly
      ]
  object BatchGetStreamKey
      extends Effect[
        BatchGetStreamKeyRequest,
        AwsError,
        zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.ivs.model.CreateChannelResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ivs.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteRecordingConfiguration
      extends Effect[DeleteRecordingConfigurationRequest, AwsError, Unit]
  object ListStreamSessions
      extends Effect[
        ListStreamSessionsRequest,
        AwsError,
        zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly
      ]
  object GetChannel
      extends Effect[
        GetChannelRequest,
        AwsError,
        zio.aws.ivs.model.GetChannelResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ivs.model.TagResourceResponse.ReadOnly
      ]
  object CreateStreamKey
      extends Effect[
        CreateStreamKeyRequest,
        AwsError,
        zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly
      ]
  object ListPlaybackKeyPairs
      extends Effect[
        ListPlaybackKeyPairsRequest,
        AwsError,
        zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly
      ]
  object GetStreamKey
      extends Effect[
        GetStreamKeyRequest,
        AwsError,
        zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly
      ]
  object GetStream
      extends Effect[
        GetStreamRequest,
        AwsError,
        zio.aws.ivs.model.GetStreamResponse.ReadOnly
      ]
  object DeleteStreamKey extends Effect[DeleteStreamKeyRequest, AwsError, Unit]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.ivs.model.UpdateChannelResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ivs] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Ivs {
          val api: IvsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Ivs = this
          def listStreams(
              request: ListStreamsRequest
          ): IO[AwsError, zio.aws.ivs.model.ListStreamsResponse.ReadOnly] =
            proxy(ListStreams, request)
          def listChannels(
              request: ListChannelsRequest
          ): IO[AwsError, zio.aws.ivs.model.ListChannelsResponse.ReadOnly] =
            proxy(ListChannels, request)
          def deletePlaybackKeyPair(request: DeletePlaybackKeyPairRequest): IO[
            AwsError,
            zio.aws.ivs.model.DeletePlaybackKeyPairResponse.ReadOnly
          ] = proxy(DeletePlaybackKeyPair, request)
          def listRecordingConfigurations(
              request: ListRecordingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly
          ] = proxy(ListRecordingConfigurations, request)
          def listStreamKeys(
              request: ListStreamKeysRequest
          ): IO[AwsError, zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly] =
            proxy(ListStreamKeys, request)
          def batchGetChannel(
              request: BatchGetChannelRequest
          ): IO[AwsError, zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly] =
            proxy(BatchGetChannel, request)
          def getPlaybackKeyPair(request: GetPlaybackKeyPairRequest): IO[
            AwsError,
            zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly
          ] = proxy(GetPlaybackKeyPair, request)
          def getStreamSession(
              request: GetStreamSessionRequest
          ): IO[AwsError, zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly] =
            proxy(GetStreamSession, request)
          def importPlaybackKeyPair(request: ImportPlaybackKeyPairRequest): IO[
            AwsError,
            zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly
          ] = proxy(ImportPlaybackKeyPair, request)
          def getRecordingConfiguration(
              request: GetRecordingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly
          ] = proxy(GetRecordingConfiguration, request)
          def putMetadata(request: PutMetadataRequest): IO[AwsError, Unit] =
            proxy(PutMetadata, request)
          def createRecordingConfiguration(
              request: CreateRecordingConfigurationRequest
          ): IO[AwsError, ReadOnly] =
            proxy(CreateRecordingConfiguration, request)
          def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit] =
            proxy(DeleteChannel, request)
          def stopStream(
              request: StopStreamRequest
          ): IO[AwsError, zio.aws.ivs.model.StopStreamResponse.ReadOnly] =
            proxy(StopStream, request)
          def batchGetStreamKey(request: BatchGetStreamKeyRequest): IO[
            AwsError,
            zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly
          ] = proxy(BatchGetStreamKey, request)
          def createChannel(
              request: CreateChannelRequest
          ): IO[AwsError, zio.aws.ivs.model.CreateChannelResponse.ReadOnly] =
            proxy(CreateChannel, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.ivs.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def deleteRecordingConfiguration(
              request: DeleteRecordingConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteRecordingConfiguration, request)
          def listStreamSessions(request: ListStreamSessionsRequest): IO[
            AwsError,
            zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly
          ] = proxy(ListStreamSessions, request)
          def getChannel(
              request: GetChannelRequest
          ): IO[AwsError, zio.aws.ivs.model.GetChannelResponse.ReadOnly] =
            proxy(GetChannel, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.ivs.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def createStreamKey(
              request: CreateStreamKeyRequest
          ): IO[AwsError, zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly] =
            proxy(CreateStreamKey, request)
          def listPlaybackKeyPairs(request: ListPlaybackKeyPairsRequest): IO[
            AwsError,
            zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly
          ] = proxy(ListPlaybackKeyPairs, request)
          def getStreamKey(
              request: GetStreamKeyRequest
          ): IO[AwsError, zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly] =
            proxy(GetStreamKey, request)
          def getStream(
              request: GetStreamRequest
          ): IO[AwsError, zio.aws.ivs.model.GetStreamResponse.ReadOnly] =
            proxy(GetStream, request)
          def deleteStreamKey(
              request: DeleteStreamKeyRequest
          ): IO[AwsError, Unit] = proxy(DeleteStreamKey, request)
          def updateChannel(
              request: UpdateChannelRequest
          ): IO[AwsError, zio.aws.ivs.model.UpdateChannelResponse.ReadOnly] =
            proxy(UpdateChannel, request)
        }
      }
    }
  }
}
