package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VideoConfiguration(
    avcLevel: Optional[String] = Optional.Absent,
    avcProfile: Optional[String] = Optional.Absent,
    codec: Optional[String] = Optional.Absent,
    encoder: Optional[String] = Optional.Absent,
    targetBitrate: Optional[Integer] = Optional.Absent,
    targetFramerate: Optional[Integer] = Optional.Absent,
    videoHeight: Optional[Integer] = Optional.Absent,
    videoWidth: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.VideoConfiguration = {
    import VideoConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.VideoConfiguration
      .builder()
      .optionallyWith(avcLevel.map(value => value: java.lang.String))(
        _.avcLevel
      )
      .optionallyWith(avcProfile.map(value => value: java.lang.String))(
        _.avcProfile
      )
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(encoder.map(value => value: java.lang.String))(_.encoder)
      .optionallyWith(targetBitrate.map(value => value: java.lang.Long))(
        _.targetBitrate
      )
      .optionallyWith(targetFramerate.map(value => value: java.lang.Long))(
        _.targetFramerate
      )
      .optionallyWith(videoHeight.map(value => value: java.lang.Long))(
        _.videoHeight
      )
      .optionallyWith(videoWidth.map(value => value: java.lang.Long))(
        _.videoWidth
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.VideoConfiguration.ReadOnly =
    zio.aws.ivs.model.VideoConfiguration.wrap(buildAwsValue())
}
object VideoConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.VideoConfiguration =
      zio.aws.ivs.model.VideoConfiguration(
        avcLevel.map(value => value),
        avcProfile.map(value => value),
        codec.map(value => value),
        encoder.map(value => value),
        targetBitrate.map(value => value),
        targetFramerate.map(value => value),
        videoHeight.map(value => value),
        videoWidth.map(value => value)
      )
    def avcLevel: Optional[String]
    def avcProfile: Optional[String]
    def codec: Optional[String]
    def encoder: Optional[String]
    def targetBitrate: Optional[Integer]
    def targetFramerate: Optional[Integer]
    def videoHeight: Optional[Integer]
    def videoWidth: Optional[Integer]
    def getAvcLevel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("avcLevel", avcLevel)
    def getAvcProfile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("avcProfile", avcProfile)
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getEncoder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encoder", encoder)
    def getTargetBitrate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetBitrate", targetBitrate)
    def getTargetFramerate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetFramerate", targetFramerate)
    def getVideoHeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("videoHeight", videoHeight)
    def getVideoWidth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("videoWidth", videoWidth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ) extends zio.aws.ivs.model.VideoConfiguration.ReadOnly {
    override val avcLevel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.avcLevel())
      .map(value => value: String)
    override val avcProfile: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.avcProfile())
      .map(value => value: String)
    override val codec: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value => value: String)
    override val encoder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encoder())
      .map(value => value: String)
    override val targetBitrate: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBitrate())
      .map(value => value: Integer)
    override val targetFramerate: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetFramerate())
      .map(value => value: Integer)
    override val videoHeight: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.videoHeight())
      .map(value => value: Integer)
    override val videoWidth: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.videoWidth())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ): zio.aws.ivs.model.VideoConfiguration.ReadOnly = new Wrapper(impl)
}
