package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.TargetIntervalSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThumbnailConfiguration(
    recordingMode: Optional[zio.aws.ivs.model.RecordingMode] = Optional.Absent,
    targetIntervalSeconds: Optional[TargetIntervalSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration = {
    import ThumbnailConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration
      .builder()
      .optionallyWith(recordingMode.map(value => value.unwrap))(_.recordingMode)
      .optionallyWith(
        targetIntervalSeconds.map(value =>
          TargetIntervalSeconds.unwrap(value): java.lang.Long
        )
      )(_.targetIntervalSeconds)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly =
    zio.aws.ivs.model.ThumbnailConfiguration.wrap(buildAwsValue())
}
object ThumbnailConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ThumbnailConfiguration =
      zio.aws.ivs.model.ThumbnailConfiguration(
        recordingMode.map(value => value),
        targetIntervalSeconds.map(value => value)
      )
    def recordingMode: Optional[zio.aws.ivs.model.RecordingMode]
    def targetIntervalSeconds: Optional[TargetIntervalSeconds]
    def getRecordingMode: ZIO[Any, AwsError, zio.aws.ivs.model.RecordingMode] =
      AwsError.unwrapOptionField("recordingMode", recordingMode)
    def getTargetIntervalSeconds: ZIO[Any, AwsError, TargetIntervalSeconds] =
      AwsError.unwrapOptionField("targetIntervalSeconds", targetIntervalSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration
  ) extends zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly {
    override val recordingMode: Optional[zio.aws.ivs.model.RecordingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordingMode())
        .map(value => zio.aws.ivs.model.RecordingMode.wrap(value))
    override val targetIntervalSeconds: Optional[TargetIntervalSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetIntervalSeconds())
        .map(value => zio.aws.ivs.model.primitives.TargetIntervalSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration
  ): zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly = new Wrapper(impl)
}
