package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    streams: Iterable[zio.aws.ivs.model.StreamSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .streams(streams.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamsResponse.ReadOnly =
    zio.aws.ivs.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamsResponse =
      zio.aws.ivs.model.ListStreamsResponse(
        nextToken.map(value => value),
        streams.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def streams: List[zio.aws.ivs.model.StreamSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreams
        : ZIO[Any, Nothing, List[zio.aws.ivs.model.StreamSummary.ReadOnly]] =
      ZIO.succeed(streams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamsResponse
  ) extends zio.aws.ivs.model.ListStreamsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
    override val streams: List[zio.aws.ivs.model.StreamSummary.ReadOnly] = impl
      .streams()
      .asScala
      .map { item =>
        zio.aws.ivs.model.StreamSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamsResponse
  ): zio.aws.ivs.model.ListStreamsResponse.ReadOnly = new Wrapper(impl)
}
