package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{
  PaginationToken,
  MaxStreamResults,
  ChannelArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamSessionsRequest(
    channelArn: ChannelArn,
    maxResults: Optional[MaxStreamResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest = {
    import ListStreamSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxStreamResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamSessionsRequest.ReadOnly =
    zio.aws.ivs.model.ListStreamSessionsRequest.wrap(buildAwsValue())
}
object ListStreamSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamSessionsRequest =
      zio.aws.ivs.model.ListStreamSessionsRequest(
        channelArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelArn: ChannelArn
    def maxResults: Optional[MaxStreamResults]
    def nextToken: Optional[PaginationToken]
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getMaxResults: ZIO[Any, AwsError, MaxStreamResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest
  ) extends zio.aws.ivs.model.ListStreamSessionsRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val maxResults: Optional[MaxStreamResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ivs.model.primitives.MaxStreamResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest
  ): zio.aws.ivs.model.ListStreamSessionsRequest.ReadOnly = new Wrapper(impl)
}
