package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.S3DestinationBucketName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3DestinationConfiguration(
    bucketName: S3DestinationBucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.S3DestinationConfiguration = {
    import S3DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.S3DestinationConfiguration
      .builder()
      .bucketName(S3DestinationBucketName.unwrap(bucketName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly =
    zio.aws.ivs.model.S3DestinationConfiguration.wrap(buildAwsValue())
}
object S3DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.S3DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.S3DestinationConfiguration =
      zio.aws.ivs.model.S3DestinationConfiguration(bucketName)
    def bucketName: S3DestinationBucketName
    def getBucketName: ZIO[Any, Nothing, S3DestinationBucketName] =
      ZIO.succeed(bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.S3DestinationConfiguration
  ) extends zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly {
    override val bucketName: S3DestinationBucketName =
      zio.aws.ivs.model.primitives.S3DestinationBucketName(impl.bucketName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.S3DestinationConfiguration
  ): zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly = new Wrapper(impl)
}
