package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PlaybackKeyPairArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPlaybackKeyPairRequest(arn: PlaybackKeyPairArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest = {
    import GetPlaybackKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest
      .builder()
      .arn(PlaybackKeyPairArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetPlaybackKeyPairRequest.ReadOnly =
    zio.aws.ivs.model.GetPlaybackKeyPairRequest.wrap(buildAwsValue())
}
object GetPlaybackKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetPlaybackKeyPairRequest =
      zio.aws.ivs.model.GetPlaybackKeyPairRequest(arn)
    def arn: PlaybackKeyPairArn
    def getArn: ZIO[Any, Nothing, PlaybackKeyPairArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest
  ) extends zio.aws.ivs.model.GetPlaybackKeyPairRequest.ReadOnly {
    override val arn: PlaybackKeyPairArn =
      zio.aws.ivs.model.primitives.PlaybackKeyPairArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest
  ): zio.aws.ivs.model.GetPlaybackKeyPairRequest.ReadOnly = new Wrapper(impl)
}
