package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ChannelRecordingConfigurationArn,
  ChannelName,
  ChannelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    arn: ChannelArn,
    authorized: Option[Boolean] = None,
    latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] = None,
    name: Option[ChannelName] = None,
    recordingConfigurationArn: Option[ChannelRecordingConfigurationArn] = None,
    `type`: Option[zio.aws.ivs.model.ChannelType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
      .builder()
      .arn(ChannelArn.unwrap(arn): java.lang.String)
      .optionallyWith(authorized.map(value => value: java.lang.Boolean))(
        _.authorized
      )
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.UpdateChannelRequest.ReadOnly =
    zio.aws.ivs.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.UpdateChannelRequest =
      zio.aws.ivs.model.UpdateChannelRequest(
        arn,
        authorized.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        recordingConfigurationArn.map(value => value),
        `type`.map(value => value)
      )
    def arn: ChannelArn
    def authorized: Option[Boolean]
    def latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Option[ChannelName]
    def recordingConfigurationArn: Option[ChannelRecordingConfigurationArn]
    def `type`: Option[zio.aws.ivs.model.ChannelType]
    def getArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(arn)
    def getAuthorized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getType: ZIO[Any, AwsError, zio.aws.ivs.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ) extends zio.aws.ivs.model.UpdateChannelRequest.ReadOnly {
    override val arn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.arn())
    override val authorized: Option[Boolean] =
      scala.Option(impl.authorized()).map(value => value: Boolean)
    override val latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] =
      scala
        .Option(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Option[ChannelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val recordingConfigurationArn
        : Option[ChannelRecordingConfigurationArn] = scala
      .Option(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val `type`: Option[zio.aws.ivs.model.ChannelType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ivs.model.ChannelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ): zio.aws.ivs.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
