package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  StreamKeyValue,
  TagValue,
  StreamKeyArn,
  ChannelArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamKey(
    arn: Option[StreamKeyArn] = None,
    channelArn: Option[ChannelArn] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    value: Option[StreamKeyValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.StreamKey = {
    import StreamKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamKey
      .builder()
      .optionallyWith(
        arn.map(value => StreamKeyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        value.map(value => StreamKeyValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamKey.ReadOnly =
    zio.aws.ivs.model.StreamKey.wrap(buildAwsValue())
}
object StreamKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamKey = zio.aws.ivs.model.StreamKey(
      arn.map(value => value),
      channelArn.map(value => value),
      tags.map(value => value),
      value.map(value => value)
    )
    def arn: Option[StreamKeyArn]
    def channelArn: Option[ChannelArn]
    def tags: Option[Map[TagKey, TagValue]]
    def value: Option[StreamKeyValue]
    def getArn: ZIO[Any, AwsError, StreamKeyArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getValue: ZIO[Any, AwsError, StreamKeyValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamKey
  ) extends zio.aws.ivs.model.StreamKey.ReadOnly {
    override val arn: Option[StreamKeyArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.StreamKeyArn(value))
    override val channelArn: Option[ChannelArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val value: Option[StreamKeyValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.ivs.model.primitives.StreamKeyValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamKey
  ): zio.aws.ivs.model.StreamKey.ReadOnly = new Wrapper(impl)
}
