package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait RecordingMode {
  def unwrap: software.amazon.awssdk.services.ivs.model.RecordingMode
}
object RecordingMode {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.RecordingMode
  ): zio.aws.ivs.model.RecordingMode = value match {
    case software.amazon.awssdk.services.ivs.model.RecordingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.RecordingMode.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.ivs.model.RecordingMode.INTERVAL =>
      val r = INTERVAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.RecordingMode {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingMode =
      software.amazon.awssdk.services.ivs.model.RecordingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.ivs.model.RecordingMode {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingMode =
      software.amazon.awssdk.services.ivs.model.RecordingMode.DISABLED
  }
  case object INTERVAL extends zio.aws.ivs.model.RecordingMode {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingMode =
      software.amazon.awssdk.services.ivs.model.RecordingMode.INTERVAL
  }
}
