package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse
      .builder()
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.ivs.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListTagsForResourceResponse =
      zio.aws.ivs.model.ListTagsForResourceResponse(tags)
    def tags: Map[TagKey, TagValue]
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse
  ) extends zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ivs.model.primitives.TagKey(key) -> zio.aws.ivs.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse
  ): zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(impl)
}
