package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRecordingConfigurationResponse(
    recordingConfiguration: Option[zio.aws.ivs.model.RecordingConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse = {
    import GetRecordingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse
      .builder()
      .optionallyWith(
        recordingConfiguration.map(value => value.buildAwsValue())
      )(_.recordingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly =
    zio.aws.ivs.model.GetRecordingConfigurationResponse.wrap(buildAwsValue())
}
object GetRecordingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetRecordingConfigurationResponse =
      zio.aws.ivs.model.GetRecordingConfigurationResponse(
        recordingConfiguration.map(value => value.asEditable)
      )
    def recordingConfiguration
        : Option[zio.aws.ivs.model.RecordingConfiguration.ReadOnly]
    def getRecordingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.RecordingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordingConfiguration",
      recordingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse
  ) extends zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly {
    override val recordingConfiguration
        : Option[zio.aws.ivs.model.RecordingConfiguration.ReadOnly] = scala
      .Option(impl.recordingConfiguration())
      .map(value => zio.aws.ivs.model.RecordingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse
  ): zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
