package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetChannelResponse(
    channel: Option[zio.aws.ivs.model.Channel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetChannelResponse = {
    import GetChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetChannelResponse.ReadOnly =
    zio.aws.ivs.model.GetChannelResponse.wrap(buildAwsValue())
}
object GetChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetChannelResponse = zio.aws.ivs.model
      .GetChannelResponse(channel.map(value => value.asEditable))
    def channel: Option[zio.aws.ivs.model.Channel.ReadOnly]
    def getChannel: ZIO[Any, AwsError, zio.aws.ivs.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetChannelResponse
  ) extends zio.aws.ivs.model.GetChannelResponse.ReadOnly {
    override val channel: Option[zio.aws.ivs.model.Channel.ReadOnly] = scala
      .Option(impl.channel())
      .map(value => zio.aws.ivs.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetChannelResponse
  ): zio.aws.ivs.model.GetChannelResponse.ReadOnly = new Wrapper(impl)
}
