package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.StreamKeyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetStreamKeyRequest(arns: Iterable[StreamKeyArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest = {
    import BatchGetStreamKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest
      .builder()
      .arns(arns.map { item =>
        StreamKeyArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchGetStreamKeyRequest.ReadOnly =
    zio.aws.ivs.model.BatchGetStreamKeyRequest.wrap(buildAwsValue())
}
object BatchGetStreamKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchGetStreamKeyRequest =
      zio.aws.ivs.model.BatchGetStreamKeyRequest(arns)
    def arns: List[StreamKeyArn]
    def getArns: ZIO[Any, Nothing, List[StreamKeyArn]] = ZIO.succeed(arns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest
  ) extends zio.aws.ivs.model.BatchGetStreamKeyRequest.ReadOnly {
    override val arns: List[StreamKeyArn] = impl
      .arns()
      .asScala
      .map { item =>
        zio.aws.ivs.model.primitives.StreamKeyArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest
  ): zio.aws.ivs.model.BatchGetStreamKeyRequest.ReadOnly = new Wrapper(impl)
}
