package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoConfiguration(
    avcLevel: Option[String] = None,
    avcProfile: Option[String] = None,
    codec: Option[String] = None,
    encoder: Option[String] = None,
    targetBitrate: Option[Integer] = None,
    targetFramerate: Option[Integer] = None,
    videoHeight: Option[Integer] = None,
    videoWidth: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.VideoConfiguration = {
    import VideoConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.VideoConfiguration
      .builder()
      .optionallyWith(avcLevel.map(value => value: java.lang.String))(
        _.avcLevel
      )
      .optionallyWith(avcProfile.map(value => value: java.lang.String))(
        _.avcProfile
      )
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(encoder.map(value => value: java.lang.String))(_.encoder)
      .optionallyWith(targetBitrate.map(value => value: java.lang.Long))(
        _.targetBitrate
      )
      .optionallyWith(targetFramerate.map(value => value: java.lang.Long))(
        _.targetFramerate
      )
      .optionallyWith(videoHeight.map(value => value: java.lang.Long))(
        _.videoHeight
      )
      .optionallyWith(videoWidth.map(value => value: java.lang.Long))(
        _.videoWidth
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.VideoConfiguration.ReadOnly =
    zio.aws.ivs.model.VideoConfiguration.wrap(buildAwsValue())
}
object VideoConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.VideoConfiguration =
      zio.aws.ivs.model.VideoConfiguration(
        avcLevel.map(value => value),
        avcProfile.map(value => value),
        codec.map(value => value),
        encoder.map(value => value),
        targetBitrate.map(value => value),
        targetFramerate.map(value => value),
        videoHeight.map(value => value),
        videoWidth.map(value => value)
      )
    def avcLevel: Option[String]
    def avcProfile: Option[String]
    def codec: Option[String]
    def encoder: Option[String]
    def targetBitrate: Option[Integer]
    def targetFramerate: Option[Integer]
    def videoHeight: Option[Integer]
    def videoWidth: Option[Integer]
    def getAvcLevel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("avcLevel", avcLevel)
    def getAvcProfile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("avcProfile", avcProfile)
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getEncoder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encoder", encoder)
    def getTargetBitrate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetBitrate", targetBitrate)
    def getTargetFramerate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetFramerate", targetFramerate)
    def getVideoHeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("videoHeight", videoHeight)
    def getVideoWidth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("videoWidth", videoWidth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ) extends zio.aws.ivs.model.VideoConfiguration.ReadOnly {
    override val avcLevel: Option[String] =
      scala.Option(impl.avcLevel()).map(value => value: String)
    override val avcProfile: Option[String] =
      scala.Option(impl.avcProfile()).map(value => value: String)
    override val codec: Option[String] =
      scala.Option(impl.codec()).map(value => value: String)
    override val encoder: Option[String] =
      scala.Option(impl.encoder()).map(value => value: String)
    override val targetBitrate: Option[Integer] =
      scala.Option(impl.targetBitrate()).map(value => value: Integer)
    override val targetFramerate: Option[Integer] =
      scala.Option(impl.targetFramerate()).map(value => value: Integer)
    override val videoHeight: Option[Integer] =
      scala.Option(impl.videoHeight()).map(value => value: Integer)
    override val videoWidth: Option[Integer] =
      scala.Option(impl.videoWidth()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.VideoConfiguration
  ): zio.aws.ivs.model.VideoConfiguration.ReadOnly = new Wrapper(impl)
}
