package zio.aws.ivs.model
import java.lang.Integer
import zio.aws.ivs.model.primitives.{
  PaginationToken,
  MaxRecordingConfigurationResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRecordingConfigurationsRequest(
    maxResults: Option[MaxRecordingConfigurationResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest = {
    import ListRecordingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxRecordingConfigurationResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.ListRecordingConfigurationsRequest.ReadOnly =
    zio.aws.ivs.model.ListRecordingConfigurationsRequest.wrap(buildAwsValue())
}
object ListRecordingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListRecordingConfigurationsRequest =
      zio.aws.ivs.model.ListRecordingConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxRecordingConfigurationResults]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxRecordingConfigurationResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest
  ) extends zio.aws.ivs.model.ListRecordingConfigurationsRequest.ReadOnly {
    override val maxResults: Option[MaxRecordingConfigurationResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ivs.model.primitives.MaxRecordingConfigurationResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest
  ): zio.aws.ivs.model.ListRecordingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
