package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.RecordingConfigurationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRecordingConfigurationRequest(
    arn: RecordingConfigurationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest = {
    import GetRecordingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest
      .builder()
      .arn(RecordingConfigurationArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetRecordingConfigurationRequest.ReadOnly =
    zio.aws.ivs.model.GetRecordingConfigurationRequest.wrap(buildAwsValue())
}
object GetRecordingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetRecordingConfigurationRequest =
      zio.aws.ivs.model.GetRecordingConfigurationRequest(arn)
    def arn: RecordingConfigurationArn
    def getArn: ZIO[Any, Nothing, RecordingConfigurationArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest
  ) extends zio.aws.ivs.model.GetRecordingConfigurationRequest.ReadOnly {
    override val arn: RecordingConfigurationArn =
      zio.aws.ivs.model.primitives.RecordingConfigurationArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest
  ): zio.aws.ivs.model.GetRecordingConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
