package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPlaybackKeyPairResponse(
    keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse = {
    import GetPlaybackKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly =
    zio.aws.ivs.model.GetPlaybackKeyPairResponse.wrap(buildAwsValue())
}
object GetPlaybackKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetPlaybackKeyPairResponse =
      zio.aws.ivs.model
        .GetPlaybackKeyPairResponse(keyPair.map(value => value.asEditable))
    def keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair.ReadOnly]
    def getKeyPair
        : ZIO[Any, AwsError, zio.aws.ivs.model.PlaybackKeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse
  ) extends zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly {
    override val keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair.ReadOnly] =
      scala
        .Option(impl.keyPair())
        .map(value => zio.aws.ivs.model.PlaybackKeyPair.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse
  ): zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly = new Wrapper(impl)
}
