package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchGetStreamKeyResponse(
    errors: Option[Iterable[zio.aws.ivs.model.BatchError]] = None,
    streamKeys: Option[Iterable[zio.aws.ivs.model.StreamKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse = {
    import BatchGetStreamKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        streamKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamKeys)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly =
    zio.aws.ivs.model.BatchGetStreamKeyResponse.wrap(buildAwsValue())
}
object BatchGetStreamKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchGetStreamKeyResponse =
      zio.aws.ivs.model.BatchGetStreamKeyResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Option[List[zio.aws.ivs.model.BatchError.ReadOnly]]
    def streamKeys: Option[List[zio.aws.ivs.model.StreamKey.ReadOnly]]
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
    def getStreamKeys
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.StreamKey.ReadOnly]] =
      AwsError.unwrapOptionField("streamKeys", streamKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ) extends zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly {
    override val errors: Option[List[zio.aws.ivs.model.BatchError.ReadOnly]] =
      scala
        .Option(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.BatchError.wrap(item)
          }.toList
        )
    override val streamKeys
        : Option[List[zio.aws.ivs.model.StreamKey.ReadOnly]] = scala
      .Option(impl.streamKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivs.model.StreamKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse
  ): zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly = new Wrapper(impl)
}
