package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  PlaybackURL,
  StreamId,
  StreamStartTime,
  StreamViewerCount,
  ChannelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Stream(
    channelArn: Option[ChannelArn] = None,
    health: Option[zio.aws.ivs.model.StreamHealth] = None,
    playbackUrl: Option[PlaybackURL] = None,
    startTime: Option[StreamStartTime] = None,
    state: Option[zio.aws.ivs.model.StreamState] = None,
    streamId: Option[StreamId] = None,
    viewerCount: Option[StreamViewerCount] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.Stream = {
    import Stream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.Stream
      .builder()
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .optionallyWith(
        playbackUrl.map(value => PlaybackURL.unwrap(value): java.lang.String)
      )(_.playbackUrl)
      .optionallyWith(
        startTime.map(value => StreamStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        viewerCount.map(value =>
          StreamViewerCount.unwrap(value): java.lang.Long
        )
      )(_.viewerCount)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.Stream.ReadOnly =
    zio.aws.ivs.model.Stream.wrap(buildAwsValue())
}
object Stream {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.Stream] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.Stream = zio.aws.ivs.model.Stream(
      channelArn.map(value => value),
      health.map(value => value),
      playbackUrl.map(value => value),
      startTime.map(value => value),
      state.map(value => value),
      streamId.map(value => value),
      viewerCount.map(value => value)
    )
    def channelArn: Option[ChannelArn]
    def health: Option[zio.aws.ivs.model.StreamHealth]
    def playbackUrl: Option[PlaybackURL]
    def startTime: Option[StreamStartTime]
    def state: Option[zio.aws.ivs.model.StreamState]
    def streamId: Option[StreamId]
    def viewerCount: Option[StreamViewerCount]
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getHealth: ZIO[Any, AwsError, zio.aws.ivs.model.StreamHealth] =
      AwsError.unwrapOptionField("health", health)
    def getPlaybackUrl: ZIO[Any, AwsError, PlaybackURL] =
      AwsError.unwrapOptionField("playbackUrl", playbackUrl)
    def getStartTime: ZIO[Any, AwsError, StreamStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ivs.model.StreamState] =
      AwsError.unwrapOptionField("state", state)
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getViewerCount: ZIO[Any, AwsError, StreamViewerCount] =
      AwsError.unwrapOptionField("viewerCount", viewerCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.Stream
  ) extends zio.aws.ivs.model.Stream.ReadOnly {
    override val channelArn: Option[ChannelArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val health: Option[zio.aws.ivs.model.StreamHealth] = scala
      .Option(impl.health())
      .map(value => zio.aws.ivs.model.StreamHealth.wrap(value))
    override val playbackUrl: Option[PlaybackURL] = scala
      .Option(impl.playbackUrl())
      .map(value => zio.aws.ivs.model.primitives.PlaybackURL(value))
    override val startTime: Option[StreamStartTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ivs.model.primitives.StreamStartTime(value))
    override val state: Option[zio.aws.ivs.model.StreamState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ivs.model.StreamState.wrap(value))
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.ivs.model.primitives.StreamId(value))
    override val viewerCount: Option[StreamViewerCount] = scala
      .Option(impl.viewerCount())
      .map(value => zio.aws.ivs.model.primitives.StreamViewerCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.Stream
  ): zio.aws.ivs.model.Stream.ReadOnly = new Wrapper(impl)
}
