package zio.aws.ivs.model
import java.lang.Integer
import zio.aws.ivs.model.primitives.{PaginationToken, MaxPlaybackKeyPairResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPlaybackKeyPairsRequest(
    maxResults: Option[MaxPlaybackKeyPairResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest = {
    import ListPlaybackKeyPairsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxPlaybackKeyPairResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly =
    zio.aws.ivs.model.ListPlaybackKeyPairsRequest.wrap(buildAwsValue())
}
object ListPlaybackKeyPairsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListPlaybackKeyPairsRequest =
      zio.aws.ivs.model.ListPlaybackKeyPairsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxPlaybackKeyPairResults]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxPlaybackKeyPairResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ) extends zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly {
    override val maxResults: Option[MaxPlaybackKeyPairResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ivs.model.primitives.MaxPlaybackKeyPairResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ): zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly = new Wrapper(impl)
}
