package zio.aws.ivs.model
import java.lang.Integer
import zio.aws.ivs.model.primitives.{
  PaginationToken,
  MaxChannelResults,
  ChannelRecordingConfigurationArn,
  ChannelName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListChannelsRequest(
    filterByName: Option[ChannelName] = None,
    filterByRecordingConfigurationArn: Option[
      ChannelRecordingConfigurationArn
    ] = None,
    maxResults: Option[MaxChannelResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListChannelsRequest = {
    import ListChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListChannelsRequest
      .builder()
      .optionallyWith(
        filterByName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.filterByName)
      .optionallyWith(
        filterByRecordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.filterByRecordingConfigurationArn)
      .optionallyWith(
        maxResults.map(value => MaxChannelResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListChannelsRequest.ReadOnly =
    zio.aws.ivs.model.ListChannelsRequest.wrap(buildAwsValue())
}
object ListChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListChannelsRequest =
      zio.aws.ivs.model.ListChannelsRequest(
        filterByName.map(value => value),
        filterByRecordingConfigurationArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterByName: Option[ChannelName]
    def filterByRecordingConfigurationArn
        : Option[ChannelRecordingConfigurationArn]
    def maxResults: Option[MaxChannelResults]
    def nextToken: Option[PaginationToken]
    def getFilterByName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("filterByName", filterByName)
    def getFilterByRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] =
      AwsError.unwrapOptionField(
        "filterByRecordingConfigurationArn",
        filterByRecordingConfigurationArn
      )
    def getMaxResults: ZIO[Any, AwsError, MaxChannelResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ) extends zio.aws.ivs.model.ListChannelsRequest.ReadOnly {
    override val filterByName: Option[ChannelName] = scala
      .Option(impl.filterByName())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val filterByRecordingConfigurationArn
        : Option[ChannelRecordingConfigurationArn] = scala
      .Option(impl.filterByRecordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val maxResults: Option[MaxChannelResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ivs.model.primitives.MaxChannelResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ): zio.aws.ivs.model.ListChannelsRequest.ReadOnly = new Wrapper(impl)
}
