package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportPlaybackKeyPairResponse(
    keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse = {
    import ImportPlaybackKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly =
    zio.aws.ivs.model.ImportPlaybackKeyPairResponse.wrap(buildAwsValue())
}
object ImportPlaybackKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ImportPlaybackKeyPairResponse =
      zio.aws.ivs.model
        .ImportPlaybackKeyPairResponse(keyPair.map(value => value.asEditable))
    def keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair.ReadOnly]
    def getKeyPair
        : ZIO[Any, AwsError, zio.aws.ivs.model.PlaybackKeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse
  ) extends zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly {
    override val keyPair: Option[zio.aws.ivs.model.PlaybackKeyPair.ReadOnly] =
      scala
        .Option(impl.keyPair())
        .map(value => zio.aws.ivs.model.PlaybackKeyPair.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse
  ): zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly = new Wrapper(
    impl
  )
}
