package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStreamKeyResponse(
    streamKey: Option[zio.aws.ivs.model.StreamKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse = {
    import GetStreamKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse
      .builder()
      .optionallyWith(streamKey.map(value => value.buildAwsValue()))(
        _.streamKey
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly =
    zio.aws.ivs.model.GetStreamKeyResponse.wrap(buildAwsValue())
}
object GetStreamKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetStreamKeyResponse = zio.aws.ivs.model
      .GetStreamKeyResponse(streamKey.map(value => value.asEditable))
    def streamKey: Option[zio.aws.ivs.model.StreamKey.ReadOnly]
    def getStreamKey: ZIO[Any, AwsError, zio.aws.ivs.model.StreamKey.ReadOnly] =
      AwsError.unwrapOptionField("streamKey", streamKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse
  ) extends zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly {
    override val streamKey: Option[zio.aws.ivs.model.StreamKey.ReadOnly] = scala
      .Option(impl.streamKey())
      .map(value => zio.aws.ivs.model.StreamKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse
  ): zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly = new Wrapper(impl)
}
