package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamKeyResponse(
    streamKey: Option[zio.aws.ivs.model.StreamKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse = {
    import CreateStreamKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse
      .builder()
      .optionallyWith(streamKey.map(value => value.buildAwsValue()))(
        _.streamKey
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly =
    zio.aws.ivs.model.CreateStreamKeyResponse.wrap(buildAwsValue())
}
object CreateStreamKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateStreamKeyResponse =
      zio.aws.ivs.model
        .CreateStreamKeyResponse(streamKey.map(value => value.asEditable))
    def streamKey: Option[zio.aws.ivs.model.StreamKey.ReadOnly]
    def getStreamKey: ZIO[Any, AwsError, zio.aws.ivs.model.StreamKey.ReadOnly] =
      AwsError.unwrapOptionField("streamKey", streamKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse
  ) extends zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly {
    override val streamKey: Option[zio.aws.ivs.model.StreamKey.ReadOnly] = scala
      .Option(impl.streamKey())
      .map(value => zio.aws.ivs.model.StreamKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse
  ): zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly = new Wrapper(impl)
}
