package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ChannelRecordingConfigurationArn,
  IsAuthorized,
  TagValue,
  ChannelName,
  ChannelArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChannelSummary(
    arn: Option[ChannelArn] = None,
    authorized: Option[IsAuthorized] = None,
    latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] = None,
    name: Option[ChannelName] = None,
    recordingConfigurationArn: Option[ChannelRecordingConfigurationArn] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ChannelSummary = {
    import ChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ChannelSummary
      .builder()
      .optionallyWith(
        arn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        authorized.map(value => IsAuthorized.unwrap(value): java.lang.Boolean)
      )(_.authorized)
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ChannelSummary.ReadOnly =
    zio.aws.ivs.model.ChannelSummary.wrap(buildAwsValue())
}
object ChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ChannelSummary =
      zio.aws.ivs.model.ChannelSummary(
        arn.map(value => value),
        authorized.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        recordingConfigurationArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[ChannelArn]
    def authorized: Option[IsAuthorized]
    def latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Option[ChannelName]
    def recordingConfigurationArn: Option[ChannelRecordingConfigurationArn]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorized: ZIO[Any, AwsError, IsAuthorized] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ChannelSummary
  ) extends zio.aws.ivs.model.ChannelSummary.ReadOnly {
    override val arn: Option[ChannelArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val authorized: Option[IsAuthorized] = scala
      .Option(impl.authorized())
      .map(value => zio.aws.ivs.model.primitives.IsAuthorized(value))
    override val latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] =
      scala
        .Option(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Option[ChannelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val recordingConfigurationArn
        : Option[ChannelRecordingConfigurationArn] = scala
      .Option(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ChannelSummary
  ): zio.aws.ivs.model.ChannelSummary.ReadOnly = new Wrapper(impl)
}
