package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  PlaybackPublicKeyMaterial,
  PlaybackKeyPairName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportPlaybackKeyPairRequest(
    name: Option[PlaybackKeyPairName] = None,
    publicKeyMaterial: PlaybackPublicKeyMaterial,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest = {
    import ImportPlaybackKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest
      .builder()
      .optionallyWith(
        name.map(value => PlaybackKeyPairName.unwrap(value): java.lang.String)
      )(_.name)
      .publicKeyMaterial(
        PlaybackPublicKeyMaterial.unwrap(publicKeyMaterial): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ImportPlaybackKeyPairRequest.ReadOnly =
    zio.aws.ivs.model.ImportPlaybackKeyPairRequest.wrap(buildAwsValue())
}
object ImportPlaybackKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ImportPlaybackKeyPairRequest =
      zio.aws.ivs.model.ImportPlaybackKeyPairRequest(
        name.map(value => value),
        publicKeyMaterial,
        tags.map(value => value)
      )
    def name: Option[PlaybackKeyPairName]
    def publicKeyMaterial: PlaybackPublicKeyMaterial
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, PlaybackKeyPairName] =
      AwsError.unwrapOptionField("name", name)
    def getPublicKeyMaterial: ZIO[Any, Nothing, PlaybackPublicKeyMaterial] =
      ZIO.succeed(publicKeyMaterial)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest
  ) extends zio.aws.ivs.model.ImportPlaybackKeyPairRequest.ReadOnly {
    override val name: Option[PlaybackKeyPairName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ivs.model.primitives.PlaybackKeyPairName(value))
    override val publicKeyMaterial: PlaybackPublicKeyMaterial =
      zio.aws.ivs.model.primitives
        .PlaybackPublicKeyMaterial(impl.publicKeyMaterial())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest
  ): zio.aws.ivs.model.ImportPlaybackKeyPairRequest.ReadOnly = new Wrapper(impl)
}
