package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DestinationConfiguration(
    s3: Option[zio.aws.ivs.model.S3DestinationConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.DestinationConfiguration = {
    import DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.DestinationConfiguration
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.DestinationConfiguration.ReadOnly =
    zio.aws.ivs.model.DestinationConfiguration.wrap(buildAwsValue())
}
object DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.DestinationConfiguration =
      zio.aws.ivs.model
        .DestinationConfiguration(s3.map(value => value.asEditable))
    def s3: Option[zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly]
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.DestinationConfiguration
  ) extends zio.aws.ivs.model.DestinationConfiguration.ReadOnly {
    override val s3
        : Option[zio.aws.ivs.model.S3DestinationConfiguration.ReadOnly] = scala
      .Option(impl.s3())
      .map(value => zio.aws.ivs.model.S3DestinationConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.DestinationConfiguration
  ): zio.aws.ivs.model.DestinationConfiguration.ReadOnly = new Wrapper(impl)
}
