package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.StreamKeyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStreamKeyRequest(arn: StreamKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest = {
    import DeleteStreamKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest
      .builder()
      .arn(StreamKeyArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.DeleteStreamKeyRequest.ReadOnly =
    zio.aws.ivs.model.DeleteStreamKeyRequest.wrap(buildAwsValue())
}
object DeleteStreamKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.DeleteStreamKeyRequest =
      zio.aws.ivs.model.DeleteStreamKeyRequest(arn)
    def arn: StreamKeyArn
    def getArn: ZIO[Any, Nothing, StreamKeyArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest
  ) extends zio.aws.ivs.model.DeleteStreamKeyRequest.ReadOnly {
    override val arn: StreamKeyArn =
      zio.aws.ivs.model.primitives.StreamKeyArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest
  ): zio.aws.ivs.model.DeleteStreamKeyRequest.ReadOnly = new Wrapper(impl)
}
